using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a lady melisande corpse" )]
	public class LadyMelisande : BaseCreature
	{
		private DateTime m_Speak;
		private bool m_SpawnedSatyrs;
		private bool m_SpawnedMinions;
		private bool IsMLBoss;
		
      [Constructable]
		public LadyMelisande() : this ( true )
		{
		}
		
		[Constructable]
		public LadyMelisande( bool ismlboss ) : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			IsMLBoss = ismlboss;
         Name = "a lady melisande";
			Body = 0x102;
			BaseSoundID = 451;

			SetStr( 420, 976 );
			SetDex( 306, 327 );
			SetInt( 1588, 1676 );

			SetHits( 7000 );	

			SetDamage( 27, 31 );
			
			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Energy, 50 );

			SetResistance( ResistanceType.Physical, 49, 55 );
			SetResistance( ResistanceType.Fire, 41, 48 );
			SetResistance( ResistanceType.Cold, 57, 63 );
			SetResistance( ResistanceType.Poison, 70, 72 );
			SetResistance( ResistanceType.Energy, 74, 80 );
			
			SetSkill( SkillName.Wrestling, 100.7, 102.0 );
			SetSkill( SkillName.Tactics, 100.1, 101.9 );
			SetSkill( SkillName.MagicResist, 120 );
			SetSkill( SkillName.Magery, 120 );
			SetSkill( SkillName.EvalInt, 120 );
			SetSkill( SkillName.Meditation, 120 );
			SetSkill( SkillName.Necromancy, 120 );
			SetSkill( SkillName.SpiritSpeak, 120 );
			
			SpawnSatyrs();
			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 10, 20 ) ) );
			
			m_Speak = DateTime.Now;			
			m_SpawnedSatyrs = false;
			m_SpawnedMinions = false;
			
			Fame = 24000;
			Karma = -9000;

			VirtualArmor = 50;
		}
		
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
      	
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosSuperBoss );
		}	
		
		public override void OnThink()
		{
			base.OnThink();
			
			if ( !m_SpawnedSatyrs && Hits < 0.5 * HitsMax )
				SpawnSatyrs();
				
			if ( !m_SpawnedMinions && Hits < 200 )
				SpawnMinions();
				
			if ( m_Speak < DateTime.Now && Utility.RandomDouble() < 0.3 )
			{
				m_Speak = DateTime.Now + TimeSpan.FromSeconds( 20 );
				Say( Utility.RandomMinMax( 1075102, 1075115 ) );
			}
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );
			
			if ( Hits != HitsMax && Utility.RandomDouble() < 0.075 )
				HealEffect( defender );
		}
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{				
// 			if ( Utility.RandomDouble() < 0.15 )
// 				SlowAttack( from );
				
			if ( willKill )
				Say( 1075118 ); // Noooooo!  You shall never defeat me.  Even if I should fall, my tree will sustain me and I will rise again.
				
			base.OnDamage( amount, from, willKill, typ );				
		}
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );		
			
// 			c.DropItem( new DiseasedBark() );
// 			if ( Utility.RandomDouble() < 0.3 )
			
			if ( IsMLBoss )
			{
				c.DropItem( new LuminescentFungi() );
			   if ( Utility.RandomDouble() < 0.4 )
			      PackItem( Loot.RandomArcanistScroll() );

            int drop = Utility.Random( 3, 6 );
			
			   for ( int i = 0; i < drop; i ++ )
				  c.DropItem( new MelisandesFermentedWine() );
         }
// 			if ( Utility.RandomDouble() < 0.6 )				
// 				c.DropItem( new ParrotItem() );
			
			if ( Utility.RandomDouble() < 0.04 )
				c.DropItem( new MelisandesHairDye() );
				
			if ( Utility.RandomDouble() < 0.04 )
				c.DropItem( new MelisandesCorrodedHatchet() );
				
// 			if ( Utility.RandomDouble() < 0.05 )
// 				c.DropItem( new AlbinoSquirrelImprisonedInCrystal() );
			
// 			if ( Utility.RandomDouble() < 0.05 )
// 				c.DropItem( new MyrmidonLegs() );
			
			if ( Utility.RandomDouble() < 0.01 )
				c.DropItem( new CrimsonCinture() );
		}

// 		public override bool CanAnimateDead{ get{ return true; } }
// 		public override BaseCreature Animates{ get{ return new LichLord(); } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override int TreasureMapLevel{ get{ return 5; } }

		public LadyMelisande( Serial serial ) : base( serial )
		{
		}		

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
			
			m_Speak = DateTime.Now;
			m_SpawnedSatyrs = false;
			m_SpawnedMinions = false;
		}
		
// 		#region Slow Attack
// 		private static Hashtable m_Table;
// 		
// 		public virtual void SlowAttack( Mobile to )
// 		{
// 			if ( m_Table == null )
// 				m_Table = new Hashtable();
// 		
// 			if ( to.Alive && to.Player && m_Table[ to ] == null )
// 			{
// 				to.Send( SpeedMode.Walk );
// 				/*to.SendLocalizedMessage( 1072069 ); // A cacophonic sound lambastes you, suppressing your ability to move.
// 				to.PlaySound( 0x584 );*/
// 				
// 				m_Table[ to ] = Timer.DelayCall( TimeSpan.FromSeconds( 30 ), new TimerStateCallback( EndSlow_Callback ), to );
// 			}
// 		}
// 		
// 		private void EndSlow_Callback( object state )
// 		{
// 			if ( state is Mobile )
// 				EndSlow( (Mobile) state );
// 		}		
// 		
// 		public virtual void EndSlow( Mobile from )
// 		{
// 			if ( m_Table == null )
// 				m_Table = new Hashtable();
// 				
// 			m_Table[ from ] = null;
// 				
// 			from.Send( SpeedMode.Disabled );
// 		}
// 		
// 		public static bool UnderSlowAttack( Mobile from )
// 		{
// 			if ( m_Table == null )
// 				m_Table = new Hashtable();
// 			
// 			return m_Table[ from ] != null;
// 		}
// 		#endregion
		
		public void HealEffect( Mobile from )
		{
			if ( from is PlayerMobile )
				Hits += from.Hits;
			else
				Hits += from.Hits / 3;
			
			PlaySound( 0xF6 );
			PlaySound( 0x1F7 );
			FixedParticles( 0x3709, 1, 30, 9963, 13, 3, EffectLayer.Head );
			
			Say( 1075117 );  // Muahahaha!  Your life essence is MINE!
// 			Say( 1075120 );  // An unholy aura surrounds Lady Melisande as her wounds begin to close.
		}
		
		public virtual void SpawnSatyrs()
		{
			Say( 1075119 ); // Awake my children!  I summon thee!
			
			m_SpawnedSatyrs = true;			
			
			Map map = this.Map;

			if ( map == null )
				return;

			int newEnslavedSatyr = Utility.RandomMinMax( 3, 6 );

			for ( int i = 0; i < newEnslavedSatyr; ++i )
			{
				EnslavedSatyr satyr = new EnslavedSatyr();

				satyr.Team = this.Team;
				satyr.FightMode = FightMode.Closest;

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 3 ) - 1;
					int y = Y + Utility.Random( 3 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				satyr.MoveToWorld( loc, map );
				satyr.Combatant = null;
			}
			
		}
		
		public virtual void SpawnMinions()
		{
			Mobile minion = null;
			
			for ( int i = 0; i < 3; i ++ )
			{
				switch ( Utility.Random( 4 ) )
				{
					default:
					case 0: minion = new InsaneDryad(); break;
					case 1: minion = new Reaper(); break;
					case 2: minion = new StoneHarpy(); break;
				}
				
				minion.MoveToWorld( Location, Map );
			}
			
			Say( 1075119 ); // Awake my children!  I summon thee!
			
			m_SpawnedMinions = true;
		}
	}
}